// V1.0	Original version Alastair Murray


float3		position_1 < bool appEdit = true; >, position_2 < bool appEdit = true; >;
float4		colour_1 < bool appEdit = true; >, colour_2 < bool appEdit = true; >;


//
// Transforms
//
float4x4 viewproj : ViewProjection
<
	string UIWidget = "None";
	bool appEdit = false;
	bool export = false;
>;



//-----------------------------------------------------------------------
//
// Vertex Shader(s)
//

// Input structure
struct VSINPUT
{
	float3 position : POSITION;
};


// Output structure (also input to the fragment shader)
struct VSOUTPUT
{
	float4 position		: POSITION;													// View-coords position
	float4 colour		: COLOR;														// Vertex colour
};


//-----------------------------------------------------------------------
//
// Vertex shader code
//

VSOUTPUT VertexShader2D( VSINPUT _input )
{
	VSOUTPUT _output;

	_output.position.xyz = position_2.xyz;
	_output.colour = colour_2;
	if( _input.position.x==0.0f )
	{
		_output.position.xyz = position_1.xyz;
		_output.colour = colour_1;
	}

	_output.position.w = 1.0f;

	return _output;
}


VSOUTPUT VertexShader3D( VSINPUT _input )
{
	VSOUTPUT _output;

	_output.position.xyz = position_2.xyz;
	_output.colour = colour_2;
	if( _input.position.x==0.0f )
	{
		_output.position.xyz = position_1.xyz;
		_output.colour = colour_1;
	}

	_output.position.w = 1.0f;

	_output.position = mul( _output.position, viewproj );

	return _output;
}



//-----------------------------------------------------------------------
//
// Fragment Shader(s)
//

// Output structure
struct PSOUTPUT
{
	float4 Colour : COLOR0;
};



//-----------------------------------------------------------------------
//
// Fragment shader code
//

PSOUTPUT BasicFragmentShader( VSOUTPUT _input )
{
	PSOUTPUT _output;
	_output.Colour = _input.colour;
	return _output;
}


//-----------------------------------------------------------------------
//
// Technique(s)
//

technique Solid2D
<
	bool supportsSpecialisedLighting = false;
	bool preservesGlobalState = false;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "Solid2D";
	int    normalDeferredID		= 0;
>
{
	pass Pass0
	{
		ZEnable = false;
		ZWriteEnable = false;
		AlphaBlendEnable = false;
		VertexShader = compile vs_1_1 VertexShader2D();
		PixelShader = compile ps_2_0 BasicFragmentShader();
	}
}

technique Solid3D
<
	bool preservesGlobalState = false;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "Solid3D";
	int    normalDeferredID		= 0;
>
{
	pass Pass0
	{
		ZEnable = true;
		ZWriteEnable = false;
		AlphaBlendEnable = true;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		BlendOp = ADD;
		VertexShader = compile vs_1_1 VertexShader3D();
		PixelShader = compile ps_2_0 BasicFragmentShader();
	}
}

technique Translucent3D
<
	bool preservesGlobalState = false;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "Translucent3D";
	int    normalDeferredID		= 2;
>
{
	pass Pass0
	{
		ZEnable = true;
		ZWriteEnable = false;
		AlphaBlendEnable = true;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		BlendOp = ADD;
		VertexShader = compile vs_1_1 VertexShader3D();
		PixelShader = compile ps_2_0 BasicFragmentShader();
	}
}

